using System.Windows.Forms;
using System.Resources;

string resxPath = Path.Combine(Path.GetDirectoryName(ScriptFilePath), Application.Settings.LanguageCode == "ja" ? "Resources.ja.resx" : "Resources.resx");
ResXResourceSet resx = new ResXResourceSet(resxPath);

// 現在の図面を取得
var doc = Application.ActiveDocument;
if(doc != null)
{
	// 選択されている図形を取得する
	var selectedShapes = doc.SelectionManager.SelectedShapes;

	// 選択数と図形タイプをチェック
	if(selectedShapes.Count == 1 && selectedShapes[0].Shape is TextShape)
	{
		// 文字図形
		TextShape text = (TextShape)selectedShapes[0].Shape;

		// 文字のアウトライン図形を取得する
		var shapes = text.GetOutlineShapes();

		// UNDO 処理を開始
		doc.UndoManager.BeginUndoUnit();

		// アウトライン図形を部分図に追加する
		foreach(var shape in shapes)
			doc.CurrentDrawing.Shapes.Add(shape);

		// UNDO 処理を終了
		doc.UndoManager.EndUndoUnit();
		
		// 終了
		return;
	}
}
// メッセージ表示
MessageBox.Show(resx.GetString("SelectShapeMessage"));

