const int ShapeParamID = 0;     // 図形パラメータID
const int BaseParamID = 3;      // 基準点パラメータID
const int LocateParamID = 6;    // 配置点パラメータID

static bool processing = false;

if(processing)
    return;

// 実行中のコマンドを取得する
var currentCommand = Application.CommandManager.CurrentCommand;

if(currentCommand == null)
    return;

// コマンドのユニーク名を比較する
// 複写コマンド、移動コマンドの場合
if(currentCommand.UniqueName == "RootPro.Edit.Copy" ||
   currentCommand.UniqueName == "RootPro.Edit.Move")
{
    bool autoSet = false;

    if(Variables.ContainsKey("AutoSetBaseParam"))
        autoSet = ((string)Variables["AutoSetBaseParam"] == "true") ? true : false;

    if(autoSet)
    {
        // パラメータアイテムを取得
        var paramItem1 = currentCommand.GetParameterItemByID(ShapeParamID);
        var paramItem2 = currentCommand.GetParameterItemByID(BaseParamID);
        var paramItem3 = currentCommand.GetParameterItemByID(LocateParamID);

        // 図形パラメータをチェック
        if(paramItem1.IsEmpty)
            return;

        // ParameterChanged イベントのパラメータを取得する
        var e = (CommandParameterChangedEventArgs)EventArgs;

        // 図形パラメータが変更されたとき
        if(e.ParameterID == ShapeParamID && (paramItem2.IsEmpty || paramItem3.IsEmpty))
        {

            Point2d basePoint = Geometry.CreatePoint(0, 0);
            bool setFlg = false;

            // 選択図形を取得する
            SelectedShapeCollection selectedShapes = ((ShapeGroupParameterItem)paramItem1).SelectedShapes;

            // 選択図形の左下の点を調べる
            foreach(SelectedShape selectedShape in selectedShapes)
            {
                Point2d[] boundingPoints = selectedShape.Shape.GetBoundingPoints();
                Point2d botmLeftPt = boundingPoints[0];

                if(setFlg)
                {
                    basePoint.X = System.Math.Min(basePoint.X, botmLeftPt.X);
                    basePoint.Y = System.Math.Min(basePoint.Y, botmLeftPt.Y);
                }
                else
                {
                    setFlg = true;
                    basePoint = botmLeftPt;
                }
            }

            // 選択図形の左下を基準点にセットする
            processing = true;
            ((PointParameterItem)paramItem2).Point = basePoint;
            processing = false;

            if(paramItem3.IsEmpty)
                currentCommand.MoveToNextParameter();
        }
    }
}