#r "System.Windows.Forms"

using System.Windows.Forms;

const int ShapeParamID = 0;     // 図形パラメータID
const int BaseParamID = 3;      // 基準点パラメータID
const int LocateParamID = 6;    // 配置点パラメータID

// 実行中のコマンドを取得する
var currentCommand = Application.CommandManager.CurrentCommand;

// コマンドのユニーク名を比較する
// 複写コマンド、移動コマンドの場合
if(currentCommand.UniqueName == "RootPro.Edit.Copy" ||
   currentCommand.UniqueName == "RootPro.Edit.Move")
{
    // Ctrl キーを押しながらコマンドを実行した場合のみ有効とする
    if((Control.ModifierKeys & Keys.Control) == Keys.Control)
    {
        // 図形パラメータアイテムを取得
        var paramItem1 = currentCommand.GetParameterItemByID(ShapeParamID);

        // 図形を選択してコマンド起動した場合
        if(!paramItem1.IsEmpty)
        {
            Point2d basePoint = Geometry.CreatePoint(0, 0);
            bool setFlg = false;

            // 選択図形を取得する
            SelectedShapeCollection selectedShapes = ((ShapeGroupParameterItem)paramItem1).SelectedShapes;

            // 選択図形の左下の点を調べる
            foreach(SelectedShape selectedShape in selectedShapes)
            {
                Point2d[] boundingPoints = selectedShape.Shape.GetBoundingPoints();
                Point2d botmLeftPt = boundingPoints[0];

                if(setFlg)
                {
                    basePoint.X = System.Math.Min(basePoint.X, botmLeftPt.X);
                    basePoint.Y = System.Math.Min(basePoint.Y, botmLeftPt.Y);
                }
                else
                {
                    setFlg = true;
                    basePoint = botmLeftPt;
                }
            }

            // 選択図形の左下を基準点にセットする
            var paramItem2 = currentCommand.GetParameterItemByID(BaseParamID);
            ((PointParameterItem)paramItem2).Point = basePoint;
            currentCommand.MoveToNextParameter();
        }

        // Variables はすべてのスクリプトで共有する System.Collections.Generic.Dictionary 型のグローバル変数です。
        // 異なるイベント間で値を渡したいときに利用します
        Variables["AutoSetBaseParam"] = "true";
    }
}