﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;

using System.Windows.Forms.Integration;
using System.Windows.Media;
using System.Windows.Media.Media3D;///Point3Dに必要


namespace RCAddInShadowDrawing
{
    public partial class RC3DForm : Form
    {
        public string AddInFullPath { get; set; }   // アドインのファイルパス

        /// <summary>
        /// 線クラス
        /// </summary>
        public class RcLine
        {
            /// <summary>
            /// コンストラクタ―
            /// </summary>
            /// <param name="startPoint"></param>
            /// <param name="endPoint"></param>
            /// <param name="color"></param>
            /// <param name="thickness"></param>
            public RcLine(Point3D startPoint, Point3D endPoint, Color color, double thickness)
            {
                this.startPoint = startPoint;
                this.endPoint = endPoint;
                this.color = color;
                this.thickness = thickness;
            }

            public Point3D startPoint; // 始点座標
            public Point3D endPoint;   // 終点座標
            public Color color;        // 色
            public double thickness;   // 線幅
        }

        public List<RcLine> Lines { get; set; }  // 線の配列

        private dynamic rc3DUserControl;

        public RC3DForm()
        {
            InitializeComponent();
        }
        
         private void RC3DForm_Load(object sender, EventArgs e)
        {
            string dir1 = Path.GetDirectoryName(AddInFullPath);
            string dllFilePathName = dir1 + "\\" + "RC3DUserControl.dll";
            System.Reflection.Assembly rcAddInToolsAsm = System.Reflection.Assembly.LoadFrom(dllFilePathName);
            var typeInfo = rcAddInToolsAsm.GetType("RC3DUserControl.UserControl1");

            string[] strings = new string[1];
            strings[0] = AddInFullPath;

            rc3DUserControl = Activator.CreateInstance(typeInfo, strings);

            // Create the ElementHost control for hosting the
            // WPF UserControl.
            ElementHost host = new ElementHost();
            host.Dock = DockStyle.Fill;

            // Create the WPF UserControl.
            // RC3DUserControl.UserControl1 uc = new RC3DUserControl.UserControl1();

            // Assign the WPF UserControl to the ElementHost control's
            // Child property.
            // host.Child = uc;
            host.Child = rc3DUserControl;

            // Add the ElementHost control to the form's
            // collection of child controls.
            this.Controls.Add(host);

            // 描画させる線を渡す          
            foreach(RcLine line in Lines)
            {
                rc3DUserControl.AddLines3D(line.startPoint, line.endPoint, line.color, line.thickness);
            }
        }


        private void CloseButton_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
