﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Runtime;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static RCAddInShadowDrawing.DockingBarUserControl;

namespace RCAddInShadowDrawing
{
    public partial class OptionForm : Form
    {
        public OptionForm()
        {
            InitializeComponent();
        }


        public void ApplyStyleFrom(UserControl parent)
        {
            this.BackColor = parent.BackColor;
            this.Font = parent.Font;
            foreach(Control ctrl in this.Controls)
            {
                ctrl.Font = parent.Font;
                ctrl.BackColor = parent.BackColor;
            }
        }


        public void SetOption(AddInSettings addInSettings)
        {
            skymapLengthValueDecimalsNumericUpDown.Value = addInSettings.skymapLengthValueDecimals;// 長さ：小数点以下桁数
            skymapTriangleLengthValueDecimalsNumericUpDown.Value = addInSettings.skymapTriangleLengthValueDecimals;// 三斜長さ：小数点以下桁数
            skymapAreaValueDecimalsNumericUpDown.Value = addInSettings.skymapAreaValueDecimals;// 面積：小数点以下桁数
            skymapAngleValueDecimalsNumericUpDown.Value = addInSettings.skymapAngleValueDecimals;// 角度：小数点以下桁数
            skyRateValueDecimalsNumericUpDown.Value = addInSettings.skyRateValueDecimals;// 天空率(%)：小数点以下桁数
            hemisphereRadiusDecimalsNumericUpDown.Value = addInSettings.hemisphereRadiusDecimals;// 天空図の半径：小数点以下桁数

            // 配置点の番号文字に対する点のサイズ(%)
            pointMarkerSizeRatioNumericUpDown.Value = (int)(addInSettings.samplingPointMarkerSizeRatio * 100.0);
        }

        public void GetOption(AddInSettings addInSettings)
        {
            addInSettings.skymapLengthValueDecimals = (int)skymapLengthValueDecimalsNumericUpDown.Value;// 長さ：小数点以下桁数
            addInSettings.skymapTriangleLengthValueDecimals = (int)skymapTriangleLengthValueDecimalsNumericUpDown.Value;// 三斜長さ：小数点以下桁数
            addInSettings.skymapAreaValueDecimals = (int)skymapAreaValueDecimalsNumericUpDown.Value;// 面積：小数点以下桁数
            addInSettings.skymapAngleValueDecimals = (int)skymapAngleValueDecimalsNumericUpDown.Value;// 角度：小数点以下桁数
            addInSettings.skyRateValueDecimals = (int)skyRateValueDecimalsNumericUpDown.Value;// 天空率(%)：小数点以下桁数
            addInSettings.hemisphereRadiusDecimals = (int)hemisphereRadiusDecimalsNumericUpDown.Value;// 天空図の半径：小数点以下桁数

            // 配置点の番号文字に対する点のサイズ(%)
            addInSettings.samplingPointMarkerSizeRatio = (double)(pointMarkerSizeRatioNumericUpDown.Value) * 0.01;
        }
    }
}



