using System;
using System.Collections.Generic;
using RootPro.RootProCAD;
using RootPro.RootProCAD.Command;
using RootPro.RootProCAD.Geometry;

/// <summary>
/// eEV󗦃vO
/// TvDockingBarUserControl.csQ
/// ́AɓV󗦂\rČvZR[hĂ
/// 
/// gp
/// ẼAhCsʂɂĂ̈؂̐ӔC͂gɂȂɂ܂B
/// ẼAhĆAvO\[X̂ρEp邱Ƃ\łB
/// @܂ÃvO\[XɓƎ̃AhC\tgEFA쐬AEL킸O҂ɔzz邱ƂF߂܂B
/// @AρEpꍇ́AЃ[gv(RootPro Corporation)쐬
/// @vO\[XQlɂĂ邱ƂO҂ɂ킩悤ɖLĂB
/// @
/// @Copyright @ 2020 RootPro Co.,Ltd. (Japan)
/// 
/// </summary>

namespace RCAddInShadowDrawing
{
    partial class DockingBarUserControl
    {

        /// <summary>
        /// V󗦂̔r{^NbN
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void skyRateCompCalcButton_Click(object sender, EventArgs e)
        {
            app.CommandManager.CancelCurrentCommand();

            // R}h̎s
            app.CommandManager.ExecuteCommand(ShadowDrawingSkyRateCompCalcCommandName);
        }

        /// <summary>
        /// }EXړCxgnh
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void CommandSkyRateCompCalc_MouseMove(Object sender, CommandMouseMoveEventArgs e)
        {
            Command command = (Command)sender;

            // I}`A̎擾
            ShapeParameterItem shapeAParameterItem = (ShapeParameterItem)command.GetParameterItemByID(selectShapeAParameterId);
            if(shapeAParameterItem == null)
                return;

            if(shapeAParameterItem.IsEmpty)
                return;

            Shape shapeA = shapeAParameterItem.Shape.Shape;
            if(!(shapeA is TextShape))
                return;

            // VA̒l擾
            if(!GetSkyRateFromText(((TextShape)shapeA).Text, out double valueA))
                return;

            // I}`B̎擾
            ShapeParameterItem shapeBParameterItem = (ShapeParameterItem)command.GetParameterItemByID(selectShapeBParameterId);
            if(shapeBParameterItem == null)
                return;

            if(shapeBParameterItem.IsEmpty)
                return;

            Shape shapeB = shapeBParameterItem.Shape.Shape;
            if(!(shapeB is TextShape))
                return;

            // VB̒l擾
            if(!GetSkyRateFromText(((TextShape)shapeB).Text, out double valueB))
                return;

            // ꎞp[^擾
            PointParameterItem pointParameterItem = (PointParameterItem)command.GetTemporaryParameterItemByID(locatePointParameterId);
            if(pointParameterItem == null)
                return;

            if(pointParameterItem.IsEmpty)
                return;

            // zu_
            Point2d locatePoint = pointParameterItem.Point;

            //hLg̎擾
            Document doc = app.ActiveDocument;
            Drawing drawing = doc.CurrentDrawing;

            // V󗦔rl쐬
            List<Shape> skyRateCompValueShapes = CreateSkyRateCompValueShapes(drawing, (TextShape)shapeA, (TextShape)shapeB, valueA, valueB, locatePoint);

            try
            {
                // o[oh`
                command.DrawShapeRubberBand(skyRateCompValueShapes.ToArray());
            }
            catch
            {
                throw;
            }

        }


        /// <summary>
        /// R}hp[^ύXCxgnh
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void CommandSkyRateCompCalc_ParameterChanged(Object sender, CommandParameterChangedEventArgs e)
        {
             Command command = (Command)sender;

            //hLg̎擾
            Document doc = app.ActiveDocument;
            Drawing drawing = doc.CurrentDrawing;

            // Va̕}`
            ShapeParameterItem shapeAParameterItem = (ShapeParameterItem)command.GetParameterItemByID(selectShapeAParameterId);
            if(shapeAParameterItem == null)
                return;

            if(shapeAParameterItem.IsEmpty)
                return;

            Shape shapeA = shapeAParameterItem.Shape.Shape;
            if(!(shapeA is TextShape))
                return;

            // Va̒l擾
            if(!GetSkyRateFromText(((TextShape)shapeA).Text, out double valueA))
            {
                e.CommandState = CommandState.ParameterError;
                return;
            }

            // Vb̕}`
            ShapeParameterItem shapeBParameterItem = (ShapeParameterItem)command.GetParameterItemByID(selectShapeBParameterId);
            if(shapeBParameterItem == null)
                return;

            if(shapeBParameterItem.IsEmpty)
                return;

            Shape shapeB = shapeBParameterItem.Shape.Shape;
            if(!(shapeB is TextShape))
                return;

            // Vb̒l擾
            if(!GetSkyRateFromText(((TextShape)shapeB).Text, out double valueB))
            {
                e.CommandState = CommandState.ParameterError;
                return;
            }

            // zu_
            PointParameterItem pointParameterItem = (PointParameterItem)command.GetParameterItemByID(locatePointParameterId);
            if(pointParameterItem == null)
                return;

            if(pointParameterItem.IsEmpty)
                return;

            // zu_
            Point2d locatePoint = pointParameterItem.Point;

            // V󗦔rl쐬
            List<Shape> skyRateCompValueShapes = CreateSkyRateCompValueShapes(drawing, (TextShape)shapeA, (TextShape)shapeB, valueA, valueB, locatePoint);

            // Undo̊Jn
            doc.UndoManager.BeginUndoUnit();

            // hLgɒǉ
            foreach(Shape shape in skyRateCompValueShapes)
            {
                // `}`ǉ
                drawing.Shapes.Add(shape);
            }

            // Undo ̏I
            doc.UndoManager.EndUndoUnit();

            // R}hs
            e.CommandState = CommandState.Execute;
        }

        /// <summary>
        /// V󗦂̕񂩂V󗦂̒l擾
        /// </summary>
        /// <param name="skyRateText"></param>
        /// <param name="skyRate"></param>
        /// <returns></returns>
        private bool GetSkyRateFromText(string text, out double skyRate)
        {
            skyRate = 0.0;

            text = text.TrimEnd();

            int textLength = text.Length;

            // "V = " 邩
            int findIndexStart = text.IndexOf(customSettings.skyRateHeadText);
            if(findIndexStart < 0)
                return false;

            int rC_SkyRateHeadTextLength = customSettings.skyRateHeadText.Length;
            int valueStartIndex = findIndexStart + rC_SkyRateHeadTextLength;

            int valueTextLength = textLength - valueStartIndex;
            if(valueTextLength <= 0)
                return false;

            string valueText = text.Substring(valueStartIndex, valueTextLength);

            // Ō"%"邩
            int findIndexEnd = valueText.LastIndexOf("%");
            if(findIndexEnd != valueText.Length - 1)
                return false;

            char[] trimChar = { '%', ' ' };
            valueText = valueText.TrimEnd(trimChar);
            valueText = valueText.TrimStart();

            // double^ɕϊ
            if(!double.TryParse(valueText, out double value))
                return false;

            skyRate = value;

            return true;
        }

        /// <summary>
        /// V󗦔rl쐬
        /// </summary>
        /// <param name="drawing"></param>
        /// <param name="textShapeA"></param>
        /// <param name="textShapeB"></param>
        /// <param name="valueA"></param>
        /// <param name="valueB"></param>
        /// <param name="locatePoint"></param>
        /// <returns></returns>
        private List<Shape> CreateSkyRateCompValueShapes(Drawing drawing, TextShape textShapeA, TextShape textShapeB, double valueA, double valueB, Point2d locatePoint)
        {
            // hLg
            Document doc = drawing.Document;
            // ݃C
            Layer currentLayer = doc.LayerTable.CurrentLayer;

            List<Shape> shapes = new List<Shape>();

            // V󗦂̔rvZ
            double resultsValue = valueA - valueB;
            double resultsValue2 = Math.Round(resultsValue, addInSettings.skyRateValueDecimals, MidpointRounding.AwayFromZero);// ľܓ
            string skymapRateValueStringFormatParamf = String.Format("{{0:f{0}}}", addInSettings.skyRateValueDecimals);
            string resultsText = String.Format(skymapRateValueStringFormatParamf, resultsValue2);

            // textShapeA ̒S_
            Point2d[] boundingBoxPointsA = textShapeA.GetBoundingBox();
            Point2d boxCenterPointA = CenterPoint(boundingBoxPointsA[0], boundingBoxPointsA[1]);
            
            // textShapeB ̒S_
            Point2d[] boundingBoxPointsB = textShapeB.GetBoundingBox();
            Point2d boxCenterPointB = CenterPoint(boundingBoxPointsB[0], boundingBoxPointsB[1]);

            // textShapeA ̒S_ textShapeB ̒S_Ԑ̊px
            double poinsAtoBAngle = 270.0;
            if(!IsPointEquals(boxCenterPointA, boxCenterPointB))
                poinsAtoBAngle = Get2PointsAngle(boxCenterPointA, boxCenterPointB);// (Degree)

            // B  A ɑ΂Ăǂ瑤ɂ邩
            int pontArea = 1;// (1:EA2:㑤A3:A4:)
            if(poinsAtoBAngle >= 45.0 && poinsAtoBAngle < 135.0)
                pontArea = 2;
            else if(poinsAtoBAngle >= 135.0 && poinsAtoBAngle < 225.0)
                pontArea = 3;
            else if(poinsAtoBAngle >= 225.0 && poinsAtoBAngle < 315.0)
                pontArea = 4;

            // ʂ̐̔zupx
            double textAngle = 0.0;
            if(pontArea == 1 || pontArea == 3)
                textAngle = 90.0;

            // Fƕt
            int colorNumber = customSettings.skyRateCompOKValueColorNumber;// V󗦔rvŽʂ̐̕F(OK)
            string addText = customSettings.skyRateCompOKMark;
            if(valueA - (valueB + customSettings.skyRateCompOKValueRange) <= RcPrecisionConfusion)// OK,NGEl(%)l
            {
                colorNumber = customSettings.skyRateCompNGValueColorNumber;// V󗦔rvŽʂ̐̕F(NG)
                addText = customSettings.skyRateCompNGMark;
            }

            resultsText += " " + addText;

            // 쐬
            TextShape textShape = app.ShapeFactory.CreateText(resultsText, locatePoint, textAngle);
            doc.TextSettings.CopyToShape(textShape);
            textShape.DirectionVertical = false;// 

            double textSizeRatio = GetSkymapTextSizeRatio();// 傫l
            textShape.FontHeight = textShapeA.FontHeight * textSizeRatio;

            // F
            textShape.ColorNumber = colorNumber;

            // C
            ((Shape)textShape).Layer = currentLayer;

            // zuʒu
            textShape.Alignment = Alignment.MiddleLeft;

            // zu_
            textShape.Point = locatePoint;

            // Xgɒǉ
            shapes.Add(textShape);

            // Ȃi<j or CR[(=)
            Point2d markTextLocatePoint = new Point2d(locatePoint.X, locatePoint.Y);
            double markTextAngle = 0.0;
            double offset = textShape.FontHeight * 2;// l̕當̐ړꏊɔzu
            string markText = "";
            if(valueA != valueB)
                markText = "";

            // B  A ̉ÊƂ
            if(pontArea == 1)
            {
                if(valueA > valueB)
                    markTextAngle = 180.0;
                else
                    markTextAngle = 0.0;

                markTextLocatePoint.Y -= offset;// 
            }
            // B  A ̏㑤̂Ƃ
            else if(pontArea == 2)
            {
                if(valueA > valueB)
                    markTextAngle = 270.0;
                else
                    markTextAngle = 90.0;

                markTextLocatePoint.X -= offset;// 
            }
            // B  A ̍̂Ƃ
            else if(pontArea == 3)
            {
                if(valueB > valueA)
                    markTextAngle = 180.0;
                else
                    markTextAngle = 0.0;

                markTextLocatePoint.Y -= offset;// 
            }
            // B  A ̉̂Ƃ
            else if(pontArea == 4)
            {
                if(valueB > valueA)
                    markTextAngle = 270.0;
                else
                    markTextAngle = 90.0;

                markTextLocatePoint.X -= offset;// 
            }

            // }[N쐬
            TextShape markTextShape = (TextShape)textShape.Clone();
            markTextShape.Text = markText;
            markTextShape.Angle = markTextAngle;
            markTextShape.Alignment = Alignment.MiddleMiddle;
            markTextShape.Point = markTextLocatePoint;

            // Xgɒǉ
            shapes.Add(markTextShape);

            return shapes;
        }

    }
}