﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Windows.Forms;
using RootPro.RootProCAD;
using RootPro.RootProCAD.Command;
using RootPro.RootProCAD.Geometry;
using RootPro.RootProCAD.UI;

namespace RCAddInShadowDrawing
{
    [System.AddIn.AddIn("AppAddIn", Version = "1.0", Publisher = "RootPro Co.,Ltd.", Description = "RootPro CAD AddInProgram")]
    public partial class AppAddIn
    {
        // このアドインのユニーク名
        public string myAddInUniqueName = "RCAddInShadowDrawingDockingBar";

        private void AppAddIn_Startup(object sender, EventArgs e)
        {
            string dockingBarName = "日影・天空率";

            var dockingBar = DockingBars.Add(myAddInUniqueName, dockingBarName, 600, 800);// ドッキングバーのサイズ初期値も指定する

            // アドインのウィンドウのタイトルはレジストリに保存されているので異なる場合はここで変える
            if(dockingBar.Text != dockingBarName)
                dockingBar.Text = dockingBarName;
            
            dockingBar.UserCtrl = new DockingBarUserControl(this);
            // フォームが表示されていない場合に表示されるためのコマンドを追加
            // RootPro CAD の「アドイン」メニューにコマンドが表示される（これをしなくても「表示」の「ユーザー定義ウィンドウ」から表示されられるが）
            string commandName = dockingBarName;
            CommandManager.AddMacroCommand(dockingBarName, commandName, MacroCommand);
        }

        private void AppAddIn_Shutdown(object sender, EventArgs e)
        {
            // 追加したコマンドを削除
            CommandManager.RemoveMacroCommand(MacroCommand);
        }

        /// <summary>
        /// マクロコマンドの実行
        /// </summary>
        private void MacroCommand()
        {
            // このアドインのドッキングバーをアクティブにする
            ActivateMyAddInDockingBar();
        }

        /// <summary>
        /// このアドインのドッキングバーをアクティブにする
        /// </summary>
        public void ActivateMyAddInDockingBar()
        {
            var dockingBar = DockingBars.Find(myAddInUniqueName);
            if(dockingBar != null)
                dockingBar.Activate();
        }

        #region VSTA generated code
        private void InternalStartup()
        {
            this.Startup += new System.EventHandler(AppAddIn_Startup);
            this.Shutdown += new System.EventHandler(AppAddIn_Shutdown);
        }
        #endregion
    
    
    }
}
