﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Reflection;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

//using _3DTools;
using System.Windows.Media.Media3D;///Point3Dに必要

namespace RC3DUserControl
{
    /// <summary>
    /// UserControl1.xaml の相互作用ロジック
    /// </summary>
    public partial class UserControl1 : UserControl
    {
        TrackballDecorator trackballDecorator;
        Viewport3D mainViewport;

        string addInFullPath;// アドインファイルパス

        // 全図形群
        List<ScreenSpaceLines3D> modelLines = new List<ScreenSpaceLines3D>();

        // 原点軸
        ScreenSpaceLines3D lineX = null;
        ScreenSpaceLines3D lineY = null;
        ScreenSpaceLines3D lineZ = null;
 
        // 動作モード
        private int functionMode = 0;// 0:Camera, 1:Model

        // カメラ
        PerspectiveCamera myPCamera;

        // 線移動メンバ変数
        private Transform3DGroup linesTransformGroup;
        private ScaleTransform3D linesTransformScale;
        private TranslateTransform3D linesTransformTranslate;


        public UserControl1(string addInFullPath)
        {
            this.addInFullPath = addInFullPath;

            // 3DTools.DLLを読み込むイベント関数
            // AppDomain.CurrentDomain.AssemblyResolve += new ResolveEventHandler(ResolveAssembly);

            InitializeComponent();

            var root = this.Content as Grid;

            // viewport
            mainViewport = new Viewport3D();

            trackballDecorator = new TrackballDecorator();
            root.Children.Add(trackballDecorator);

            trackballDecorator.Content = mainViewport;

            // 動作モード
            SetFunctionMode(functionMode);

            // カメラの初期化
            InitializeCamera();

            // 線移動メンバ変数の初期化
            InitializeLinesTransform();

            // 原点軸
            AxisCheckBox.IsChecked = true;
        }

        private Assembly ResolveAssembly(object sender, ResolveEventArgs args)
        {
            string dir1 = System.IO.Path.GetDirectoryName(addInFullPath);
            string dllFilePathName = dir1 + "\\" + "3DTools.dll";

            AssemblyName assemblyName = new AssemblyName(args.Name);
            return Assembly.LoadFrom(dllFilePathName);
        }


        /// <summary>
        /// カメラの初期化
        /// </summary>
        private void InitializeCamera()
        {
            Point3D position = new Point3D(0, -2.5, 1.0);// カメラの位置
            Vector3D lookDirection = new Vector3D(0, 1, -0.2);// カメラの投影の方向
            Vector3D upDirection = new Vector3D(0, 0, 1);// 観察者の視点に従って上向きの方向
            double fieldOfView = 50.0;// カメラの投影角度の幅。度。

            myPCamera = new PerspectiveCamera(position, lookDirection, upDirection, fieldOfView);
            myPCamera.FarPlaneDistance = 10.0;
            mainViewport.Camera = myPCamera;
        }


        /// <summary>
        /// 線移動メンバ変数の初期化
        /// </summary>
        private void InitializeLinesTransform()
        {
            linesTransformGroup = new Transform3DGroup();

            linesTransformScale = new ScaleTransform3D();
            linesTransformGroup.Children.Add(linesTransformScale);

            linesTransformTranslate = new TranslateTransform3D();
            linesTransformGroup.Children.Add(linesTransformTranslate);
        }

        /// <summary>
        /// 座標軸の表示チェックボックスOn
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Axis_CheckBox_Checked(object sender, RoutedEventArgs e)
        {
             SetOriginAxisLines();
        }

        /// <summary>
        /// 座標軸の表示チェックボックスOff
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Axis_CheckBox_UnChecked(object sender, RoutedEventArgs e)
        {
            RemoveOriginAxisLines();
        }

        /// <summary>
        /// 原点軸セット
        /// </summary>
        public void SetOriginAxisLines()
        {
            // 原点軸
            double axisLen = 0.2;
            lineX = new ScreenSpaceLines3D();
            lineX.Points.Add(new Point3D(0, 0, 0));
            lineX.Points.Add(new Point3D(axisLen, 0, 0));
            lineX.Color = Colors.Orange;
            lineX.Thickness = 1;
            mainViewport.Children.Add(lineX);

            lineY = new ScreenSpaceLines3D();
            lineY.Points.Add(new Point3D(0, 0, 0));
            lineY.Points.Add(new Point3D(0, axisLen, 0));
            lineY.Color = Colors.Green;
            lineY.Thickness = 1;
            mainViewport.Children.Add(lineY);

            lineZ = new ScreenSpaceLines3D();
            lineZ.Points.Add(new Point3D(0, 0, 0));
            lineZ.Points.Add(new Point3D(0, 0, axisLen));
            lineZ.Color = Colors.Blue;
            lineZ.Thickness = 1;
            mainViewport.Children.Add(lineZ);
        }

        /// <summary>
        /// 原点軸の削除
        /// </summary>
        public void RemoveOriginAxisLines()
        {
            if(lineX != null)
            {
                mainViewport.Children.Remove(lineX);
                lineX = null;
            }

            if(lineY != null)
            {
                mainViewport.Children.Remove(lineY);
                lineY = null;
            }

            if(lineZ != null)
            {
                mainViewport.Children.Remove(lineZ);
                lineZ = null;
            }
        }

        /// <summary>
        /// 線のデータ追加
        /// </summary>
        /// <param name="p1"></param>
        /// <param name="p2"></param>
        /// <param name="color"></param>
        /// <param name="thickness"></param>
        public void AddLines3D(Point3D p1, Point3D p2, Color color, double thickness)
        {
            ScreenSpaceLines3D lines3D = new ScreenSpaceLines3D();
            lines3D.Points.Add(p1);
            lines3D.Points.Add(p2);
            lines3D.Color = color;
            lines3D.Thickness = thickness;

            modelLines.Add(lines3D);
            mainViewport.Children.Add(lines3D);
        }

        static readonly Dictionary<string, Vector3D> Axes = new Dictionary<string, Vector3D>
        {
            { "-x", Vector3D.Parse("-1,0,0") },
            { "+x", Vector3D.Parse("1,0,0") },
            { "-y", Vector3D.Parse("0,-1,0") },
            { "+y", Vector3D.Parse("0,1,0") },
            { "-z", Vector3D.Parse("0,0,-1") },
            { "+z", Vector3D.Parse("0,0,1") },
        };


        private void modeCxmOpened(object sender, RoutedEventArgs e)
        {
        }

        /// <summary>
        /// コンテキストメニューの選択時の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Mode_Click(object sender, RoutedEventArgs e)
        {
            var menuItem = (MenuItem)sender;
            var command = (string)menuItem.CommandParameter;

             // 動作モード
            if(command == "Camera")
                SetFunctionMode(0);
            else if(command == "Model")
                SetFunctionMode(1);
        }


        /// <summary>
        /// モードのセット
        /// </summary>
        /// <param name="command"></param>
        public void SetFunctionMode(int mode)
        {
            if(mode == 0)
            {
                functionMode = 0;
                modeTextBlock.Text = "Mode:Camera";
                cxmItemCamera.IsChecked = true;
                cxmItemModel.IsChecked = false;
            }
            else if(mode == 1)
            {
                functionMode = 1;
                modeTextBlock.Text = "Mode:Model";
                cxmItemCamera.IsChecked = false;
                cxmItemModel.IsChecked = true;
            }
        }

        /// <summary>
        /// リセットボタンクリック時の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Reset_Click(object sender, RoutedEventArgs e)
        {
            InutTransform();
        }

        /// <summary>
        /// 移動状態初期化
        /// </summary>
        private void InutTransform()
        {
            //InitializeCamera();
            trackballDecorator.InitTransform();

            InitializeLinesTransform();

            foreach(ScreenSpaceLines3D lines in modelLines)
                lines.Transform = linesTransformGroup;
        }

        /// <summary>
        /// 回転ボタンクリック時の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Rotate_Click(object sender, RoutedEventArgs e)
        {
            var button = (RepeatButton)sender;
            var command = (string)button.CommandParameter;
            RotationFunction(command);
        }

        
        /// <summary>
        /// 拡大・縮小ボタンクリック時の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Zoom_Click(object sender, RoutedEventArgs e)
        {
            var button = (RepeatButton)sender;
            var command = (string)button.CommandParameter;
            ZoomFunction(command);
        }

        /// <summary>
        /// 移動ボタンクリック時の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Pan_Click(object sender, RoutedEventArgs e)
        {
            var button = (RepeatButton)sender;
            var command = (string)button.CommandParameter;
            PanFunction(command);
        }


        /// <summary>
        /// 回転
        /// </summary>
        /// <param name="parameter">"-x"、"+x"、"-y"、"+y"、"-z"、"+z"</param>
        public void RotationFunction(string parameter)
        {
            if(functionMode == 0)
                RotationCamera(parameter);
            else if(functionMode == 1)
                RotationModel(parameter);
        }


        /// <summary>
        /// 拡大縮小
        /// </summary>
        /// <param name="parameter">"+":拡大、"-":縮小</param>
        public void ZoomFunction(string parameter)
        {
            if(functionMode == 0)
                ZoomCamera(parameter);
            else if(functionMode == 1)
                ZoomModel(parameter);
        }

        /// <summary>
        /// パンニング
        /// </summary>
        /// <param name="parameter">"-x"、"+x"、"-y"、"+y"、"-z"、"+z"</param>        
        public void PanFunction(string parameter)
        {
            if(functionMode == 0)
                PanCamera(parameter);
            else if(functionMode == 1)
                PanModel(parameter);
        }

        /// <summary>
        /// カメラを回転
        /// </summary>
        public void RotationCamera(string parameter)
        {
            var axis = Axes[parameter];
            double angle = 5.0;

            trackballDecorator.SetRotation(axis, angle);
        }


        /// <summary>
        /// カメラをズーム
        /// </summary>
        public void ZoomCamera(string parameter)
        {
            double scale = 1.0;
            if(parameter == "-") // ZoomOut
                scale = 1.1;
            else if(parameter == "+") // ZoomIn
                scale = 0.9;

            if(scale < 1.0 && trackballDecorator.ScaleTransform.ScaleX < 0.05)
                return;

            if(scale > 1.0 && trackballDecorator.ScaleTransform.ScaleX > 5.0)
                return;

            trackballDecorator.SetScale(scale);
        }

        /// <summary>
        /// カメラをパンニング
        /// </summary>
        /// <param name="parameter">"-x"、"+x"、"-y"、"+y"、"-z"、"+z"</param>
        public void PanCamera(string parameter)
        {
            double dist = 0.1;// 移動量
            double moveX = 0;
            double moveY = 0;
            double moveZ = 0;

            if(parameter == "-x")
                moveX = -1.0 * dist; 
            else if(parameter == "+x")
                moveX = dist; 
            else if(parameter == "-y")
                moveY = -1.0 * dist; 
            else if(parameter == "+y")
                moveY = dist; 
            else if(parameter == "-z")
                moveZ = -1.0 * dist; 
            else if(parameter == "+z")
                moveZ = dist;

            trackballDecorator.Move(moveX, moveY, moveZ);
        }

        /// <summary>
        /// 線自体を回転
        /// </summary>
        /// <param name="parameter">"-x"、"+x"、"-y"、"+y"、"-z"、"+z"</param>
        public void RotationModel(string parameter)
        {
            var axis = Axes[parameter];

            AxisAngleRotation3D addLinesAxisAngleRotation = new AxisAngleRotation3D(axis, 5);
            linesTransformGroup.Children.Add(new RotateTransform3D(addLinesAxisAngleRotation));

            // 線自体を回転
            foreach(ScreenSpaceLines3D lines in modelLines)
                lines.Transform = linesTransformGroup;
        }

        /// <summary>
        /// 線自体を拡大縮小
        /// </summary>
        /// <param name="parameter"></param>
        public void ZoomModel(string parameter)
        {
             double scale = 1.0;
            if(parameter == "-")
                scale = 0.9;
            else if(parameter == "+")
                scale = 1.1;

            if(scale < 1.0 && linesTransformScale.ScaleX < 0.05)
                return;

            if(scale > 1.0 && linesTransformScale.ScaleX > 5.0)
                return;

            // 線自体を拡大縮小
            linesTransformScale.ScaleX *= scale;
            linesTransformScale.ScaleY *= scale;
            linesTransformScale.ScaleZ *= scale;

            foreach(ScreenSpaceLines3D lines in modelLines)
                lines.Transform = linesTransformGroup;
        }

        /// <summary>
        /// 線自体を移動
        /// </summary>
        /// <param name="parameter">"-x"、"+x"、"-y"、"+y"、"-z"、"+z"</param>
        public void PanModel(string parameter)
        {
            double dist = 0.1;// 移動量
            double moveX = 0;
            double moveY = 0;
            double moveZ = 0;

            if(parameter == "-x")
                moveX = -1.0 * dist; 
            else if(parameter == "+x")
                moveX = dist; 
            else if(parameter == "-y")
                moveY = -1.0 * dist; 
            else if(parameter == "+y")
                moveY = dist; 
            else if(parameter == "-z")
                moveZ = -1.0 * dist; 
            else if(parameter == "+z")
                moveZ = dist; 

            // 線自体を移動
            linesTransformTranslate.OffsetX += moveX;
            linesTransformTranslate.OffsetY += moveY;
            linesTransformTranslate.OffsetZ += moveZ;

            foreach(ScreenSpaceLines3D lines in modelLines)
                lines.Transform = linesTransformGroup;
        }

    }
}
